﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace MojaDrugaGra;

public class Game1 : Game
{
    private GraphicsDeviceManager _graphics;
    private SpriteBatch _spriteBatch;

    public Game1()
    {
        _graphics = new GraphicsDeviceManager(this);
        Content.RootDirectory = "Content";
        IsMouseVisible = true;

        _graphics.GraphicsProfile = GraphicsProfile.Reach;
    }

    private Effect efekt;
    private Matrix MacierzSwiata, MacierzWidoku, MacierzRzutowania;
    private Prostopadloscian prostopadloscian;

    protected override void Initialize()
    {
        MacierzSwiata = Matrix.Identity;
        MacierzWidoku = Matrix.CreateLookAt(2.5f * Vector3.UnitZ, Vector3.Zero, Vector3.Up);
        MacierzRzutowania = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver2, GraphicsDevice.Viewport.AspectRatio, 1, 100);

        base.Initialize();
    }

    protected override void LoadContent()
    {
        _spriteBatch = new SpriteBatch(GraphicsDevice);

        efekt = Content.Load<Effect>("efekt");
        efekt.Parameters["Kolor"].SetValue(Color.Lime.ToVector4());
        efekt.Parameters["KopiujKolorWerteksu"].SetValue(false);
        efekt.Parameters["WVP"].SetValue(MacierzSwiata * MacierzWidoku * MacierzRzutowania);

        string parametry = "Parametry efektu: ";
        foreach (var parametr in efekt.Parameters)
            parametry += parametr.Name + " : " + parametr.Semantic + ";  ";
        this.Window.Title = parametry;

        prostopadloscian = new Prostopadloscian(this, efekt, 1.5f, 1.0f, 2.0f, Color.Yellow);
        this.Components.Add(prostopadloscian);        

    }

    protected override void Update(GameTime gameTime)
    {
        KeyboardState stanKlawiatury = Keyboard.GetState();
        GamePadState stanGamepada = GamePad.GetState(PlayerIndex.One);

        if (stanGamepada.Buttons.Back == ButtonState.Pressed || stanKlawiatury.IsKeyDown(Keys.Escape))
            Exit();

        // TODO: Add your update logic here
        float katObrotu = 0.01f;        
        if (stanKlawiatury.IsKeyDown(Keys.LeftShift) || stanKlawiatury.IsKeyDown(Keys.RightShift))
            katObrotu *= 10;

        if (stanKlawiatury.IsKeyDown(Keys.Left) || stanGamepada.IsButtonDown(Buttons.DPadLeft))
            MacierzSwiata *= Matrix.CreateRotationY(katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.Right) || stanGamepada.IsButtonDown(Buttons.DPadRight))
            MacierzSwiata *= Matrix.CreateRotationY(-katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.Up) || stanGamepada.IsButtonDown(Buttons.DPadUp))
            MacierzSwiata *= Matrix.CreateRotationX(katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.Down) || stanGamepada.IsButtonDown(Buttons.DPadDown))
            MacierzSwiata *= Matrix.CreateRotationX(-katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.OemPeriod))
            MacierzSwiata *= Matrix.CreateRotationZ(katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.OemComma))
            MacierzSwiata *= Matrix.CreateRotationZ(-katObrotu);        

        Vector2 wychylenieLewegoGrzybka = stanGamepada.ThumbSticks.Left;
        MacierzSwiata *= Matrix.CreateRotationY(katObrotu * wychylenieLewegoGrzybka.X);
        MacierzSwiata *= Matrix.CreateRotationX(-katObrotu * wychylenieLewegoGrzybka.Y);

        Vector2 wychyleniePrawegoGrzybka = stanGamepada.ThumbSticks.Right;
        MacierzSwiata *= Matrix.CreateRotationY(10 * katObrotu * wychyleniePrawegoGrzybka.X);
        MacierzSwiata *= Matrix.CreateRotationX(-10 * katObrotu * wychyleniePrawegoGrzybka.Y);

        efekt.Parameters["WVP"].SetValue(MacierzSwiata * MacierzWidoku * MacierzRzutowania);

        base.Update(gameTime);
    }

    protected override void Draw(GameTime gameTime)
    {
        GraphicsDevice.Clear(Color.Black);

        // TODO: Add your drawing code here

        base.Draw(gameTime);
    }
}
